/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JICPPacket {
    public static final int MAX_SIZE = 1000000;
    private byte type;
    private byte info;
    private byte sessionID = (byte)-1;
    private String recipientID;
    private byte[] data;

    private JICPPacket() {
    }

    public JICPPacket(byte type, byte info, byte[] data) {
        this.init(type, info, null, data);
    }

    public JICPPacket(byte type, byte info, String recipientID, byte[] data) {
        this.init(type, info, recipientID, data);
    }

    public JICPPacket(String explanation, Exception e) {
        if (e != null) {
            explanation = explanation + ": " + e.getClass().getName() + "#" + e.getMessage();
        }
        this.init((byte)100, (byte)0, null, explanation.getBytes());
    }

    private void init(byte t, byte i, String id, byte[] d) {
        this.type = t;
        this.info = i;
        this.sessionID = (byte)-1;
        this.data = d;
        this.setRecipientID(id);
        if (this.data != null) {
            this.info = (byte)(this.info | 8);
        }
    }

    public byte getType() {
        return this.type;
    }

    public byte getInfo() {
        return this.info;
    }

    public byte getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(byte id) {
        this.sessionID = id;
        this.info = this.sessionID >= 0 ? (byte)(this.info | 4) : (byte)(this.info & 0xFFFFFFFB);
    }

    public String getRecipientID() {
        return this.recipientID;
    }

    public void setRecipientID(String id) {
        this.recipientID = id;
        this.info = this.recipientID != null ? (byte)(this.info | 2) : (byte)(this.info & 0xFFFFFFFD);
    }

    public void setTerminatedInfo(boolean set) {
        this.info = set ? (byte)(this.info | 0x40) : (byte)(this.info & 0xFFFFFFBF);
    }

    public byte[] getData() {
        return this.data;
    }

    public int writeTo(OutputStream out) throws IOException {
        int cnt = 2;
        out.write(this.type);
        out.write(this.info);
        if ((this.info & 4) != 0) {
            out.write(this.sessionID);
            ++cnt;
        }
        if ((this.info & 2) != 0) {
            out.write(this.recipientID.length());
            out.write(this.recipientID.getBytes());
            cnt += 1 + this.recipientID.length();
        }
        if (this.data != null) {
            int size = this.data.length;
            out.write(size);
            out.write(size >> 8);
            out.write(size >> 16);
            out.write(size >> 24);
            cnt += 4;
            if (size > 0) {
                out.write(this.data, 0, size);
                cnt += size;
            }
        }
        return cnt;
    }

    public static JICPPacket readFrom(InputStream in) throws IOException {
        JICPPacket p = new JICPPacket();
        p.type = JICPPacket.read(in);
        p.info = JICPPacket.read(in);
        if ((p.info & 4) != 0) {
            p.sessionID = JICPPacket.read(in);
        }
        if ((p.info & 2) != 0) {
            int size = JICPPacket.read(in) & 0xFF;
            byte[] bb = new byte[size];
            in.read(bb, 0, size);
            p.recipientID = new String(bb);
        }
        if ((p.info & 8) != 0) {
            byte b1 = JICPPacket.read(in);
            byte b2 = JICPPacket.read(in);
            int size = b2 << 8 & 0xFF00 | b1 & 0xFF;
            byte b3 = JICPPacket.read(in);
            byte b4 = JICPPacket.read(in);
            if ((size |= b4 << 24 & 0xFF000000 | b3 << 16 & 0xFF0000) == 0) {
                p.data = new byte[0];
            } else {
                int n;
                p.data = new byte[size];
                int cnt = 0;
                do {
                    if ((n = in.read(p.data, cnt, size - cnt)) != -1) continue;
                    throw new EOFException("EOF reading packet data");
                } while ((cnt += n) < size);
            }
        }
        return p;
    }

    private static final byte read(InputStream in) throws IOException {
        int i = in.read();
        if (i == -1) {
            throw new EOFException("EOF reading packet header");
        }
        return (byte)i;
    }

    public int getLength() {
        int cnt = 2;
        if ((this.info & 4) != 0) {
            ++cnt;
        }
        if ((this.info & 2) != 0) {
            cnt += 1 + this.recipientID.getBytes().length;
        }
        if ((this.info & 8) != 0) {
            cnt += 2 + this.data.length;
        }
        return cnt;
    }
}

